/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.attachment.TipsyHeartsAttachment;

public record SyncNumbedHeartsClientboundPacket(int entityId, float numbedHealth, int ticksUntilDamage) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BrewinAndChewin.asResource("sync_numbed_hearts");
    public static final CustomPacketPayload.Type<SyncNumbedHeartsClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncNumbedHeartsClientboundPacket> STREAM_CODEC = StreamCodec.of(SyncNumbedHeartsClientboundPacket::encode, SyncNumbedHeartsClientboundPacket::new);

    public SyncNumbedHeartsClientboundPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), buf.readFloat(), buf.readInt());
    }

    public static void encode(RegistryFriendlyByteBuf buf, SyncNumbedHeartsClientboundPacket packet) {
        buf.writeInt(packet.entityId());
        buf.writeFloat(packet.numbedHealth());
        buf.writeInt(packet.ticksUntilDamage());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId());
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            BrewinAndChewin.getHelper().setTipsyHeartsAttachment(living, this.numbedHealth < 1.0E-5f ? null : new TipsyHeartsAttachment(this.numbedHealth, this.ticksUntilDamage));
        });
    }
}

