/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.block.entity.container.KegStackedContents;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.mixin.ServerPlaceRecipeAccessor;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegPlaceRecipe
extends ServerPlaceRecipe<KegRecipeWrapper, KegFermentingRecipe> {
    private final RecipeManager manager;

    public KegPlaceRecipe(KegMenu menu, RecipeManager manager) {
        super((RecipeBookMenu)menu);
        this.manager = manager;
        ((ServerPlaceRecipeAccessor)((Object)this)).brewinandchewin$setStackedContents(new KegStackedContents(menu, manager));
    }

    protected void handleRecipeClicked(RecipeHolder<KegFermentingRecipe> recipe, boolean placeAll) {
        KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe.value();
        KegMenu menu = (KegMenu)this.menu;
        boolean flag = menu.recipeMatches(recipe);
        ((KegStackedContents)this.stackedContents).setIgnoreFluids(true);
        int biggestCraftableStack = this.stackedContents.getBiggestCraftableStack(recipe, null);
        ((KegStackedContents)this.stackedContents).setIgnoreFluids(false);
        boolean shouldHandleItems = true;
        boolean shouldHandleFluid = true;
        if (flag) {
            for (int j = 0; j < menu.getGridHeight() * menu.getGridWidth() + 1; ++j) {
                ItemStack itemstack;
                if (j == menu.getResultSlotIndex() || (itemstack = menu.getSlot(j).getItem()).isEmpty() || Math.min(biggestCraftableStack, itemstack.getMaxStackSize()) >= itemstack.getCount() + 1) continue;
                shouldHandleItems = false;
            }
        }
        if (fermentingRecipe.getFluidIngredient().isEmpty() && menu.kegTank.isEmpty() || fermentingRecipe.getFluidIngredient().isPresent() && fermentingRecipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) && menu.kegTank.getAbstractedFluid().amount() >= menu.kegTank.getFluidCapacity()) {
            shouldHandleFluid = false;
        }
        if (!shouldHandleItems && !shouldHandleFluid) {
            return;
        }
        ((KegStackedContents)this.stackedContents).setIgnoreItems(!shouldHandleItems);
        int stackSize = placeAll ? biggestCraftableStack : (!shouldHandleFluid ? this.getStackSize(false, biggestCraftableStack, flag) : 1);
        IntArrayList intlist = new IntArrayList();
        if (this.stackedContents.canCraft(recipe.value(), (IntList)intlist, stackSize)) {
            int k = stackSize;
            IntListIterator intListIterator = intlist.iterator();
            while (intListIterator.hasNext()) {
                int l = (Integer)intListIterator.next();
                int i1 = StackedContents.fromStackingIndex((int)l).getMaxStackSize();
                if (((KegStackedContents)this.stackedContents).isFluidItem(recipe.value(), l) || i1 >= k) continue;
                k = i1;
            }
            if (this.stackedContents.canCraft((Recipe)fermentingRecipe, (IntList)intlist, k) && shouldHandleFluid) {
                KegBlockEntity blockEntity = menu.blockEntity;
                AbstractedFluidTank kegTank = menu.kegTank;
                if (fermentingRecipe.getFluidIngredient().isEmpty()) {
                    if (!kegTank.isEmpty()) {
                        for (int i = 0; i < this.inventory.items.size() && !kegTank.isEmpty(); ++i) {
                            ItemStack stack2 = (ItemStack)this.inventory.items.get(i);
                            List<KegPouringRecipe> pouringRecipes = this.manager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.getFluid(stack2).matches(kegTank.getAbstractedFluid())).toList();
                            Optional<KegPouringRecipe> optionalData = pouringRecipes.stream().filter(pouring -> {
                                if (pouring.isStrict()) {
                                    return ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)pouring.getContainer());
                                }
                                return ItemStack.isSameItem((ItemStack)stack2, (ItemStack)pouring.getContainer());
                            }).findFirst();
                            if (!optionalData.isPresent()) continue;
                            int finalI = i;
                            blockEntity.extractInGui(stack2, stack2.getCount()).forEach(s -> {
                                if (!this.inventory.add(((ItemStack)this.inventory.items.get(finalI)).isEmpty() ? finalI : this.inventory.getSlotWithRemainingSpace(s), s)) {
                                    this.inventory.player.drop(s, false);
                                }
                            });
                        }
                    }
                } else {
                    Optional<KegPouringRecipe> optionalData;
                    List<KegPouringRecipe> pouringRecipes;
                    boolean shouldRemoveIndex;
                    ArrayList<RecipeItem> extractItems = new ArrayList<RecipeItem>();
                    boolean bl = shouldRemoveIndex = !kegTank.isEmpty() && !fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid()) || kegTank.getAbstractedFluid().amount() < fermentingRecipe.getFluidIngredient().get().amount();
                    if (!kegTank.isEmpty() && !fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid())) {
                        long fluidToExtract = kegTank.getAbstractedFluid().amount();
                        for (int i = 0; i < this.inventory.items.size(); ++i) {
                            ItemStack stack2 = (ItemStack)this.inventory.items.get(i);
                            pouringRecipes = this.manager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.getFluid(stack2).matches(kegTank.getAbstractedFluid())).toList();
                            optionalData = pouringRecipes.stream().filter(pouring -> {
                                if (stack2.isEmpty()) {
                                    return false;
                                }
                                if (pouring.isStrict()) {
                                    return ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)pouring.getContainer());
                                }
                                return ItemStack.isSameItem((ItemStack)stack2, (ItemStack)pouring.getContainer());
                            }).findFirst();
                            if (!optionalData.isPresent()) continue;
                            int itemAmount = (int)Math.min(fermentingRecipe.getFluidIngredient().get().amount() / optionalData.get().getRawFluid().amount(), (long)stack2.getCount());
                            ItemStack inputStack = optionalData.get().getResultItem((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
                            if (extractItems.stream().anyMatch(recipeItem -> recipeItem.fluidAmount > ((KegPouringRecipe)optionalData.get()).getRawFluid().amount())) continue;
                            if (extractItems.stream().anyMatch(recipeItem -> recipeItem.fluidAmount < ((KegPouringRecipe)optionalData.get()).getRawFluid().amount())) {
                                fluidToExtract = kegTank.getAbstractedFluid().amount();
                                extractItems.clear();
                            }
                            if (fluidToExtract <= 0L) continue;
                            extractItems.add(new RecipeItem(i, itemAmount, optionalData.get().getRawFluid().amount() * (long)itemAmount, optionalData.get().getContainer().copyWithCount(itemAmount), inputStack.copyWithCount(itemAmount)));
                            fluidToExtract -= optionalData.get().getRawFluid().amount() * (long)itemAmount;
                        }
                        if (fluidToExtract > 0L) {
                            return;
                        }
                        List<RecipeItem> temporaryExtracts = List.copyOf(extractItems);
                        extractItems.clear();
                        for (RecipeItem extractItem : temporaryExtracts) {
                            ((ItemStack)this.inventory.items.get(extractItem.slot)).shrink(extractItem.maxInsert);
                            ItemStack copiedContainer = extractItem.container.copy();
                            List<ItemStack> extracted = blockEntity.extractInGui(extractItem.container, extractItem.maxInsert);
                            extractItems.addAll(extracted.stream().map(stack -> new RecipeItem(extractItem.slot, extractItem.maxInsert, extractItem.fluidAmount, copiedContainer, (ItemStack)stack)).toList());
                        }
                        if (!extractItems.isEmpty()) {
                            intlist.removeInt(intlist.size() - 1);
                        }
                    }
                    ArrayList<RecipeItem> insertItems = new ArrayList<RecipeItem>();
                    int fluidToInsert = 0;
                    for (int i = 0; i < this.inventory.items.size(); ++i) {
                        ItemStack stack3 = (ItemStack)this.inventory.items.get(i);
                        pouringRecipes = this.manager.getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.canFill() && fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getFluid(stack3))).toList();
                        optionalData = pouringRecipes.stream().filter(pouring -> {
                            if (pouring.isStrict()) {
                                return ItemStack.isSameItemSameComponents((ItemStack)stack3, (ItemStack)pouring.getOutput());
                            }
                            return ItemStack.isSameItem((ItemStack)stack3, (ItemStack)pouring.getOutput());
                        }).findFirst();
                        if (!optionalData.isPresent()) continue;
                        int itemAmount = (int)Mth.clamp((long)((fermentingRecipe.getFluidIngredient().get().amount() / optionalData.get().getRawFluid().amount() - kegTank.getAbstractedFluid().amount() % fermentingRecipe.getFluidIngredient().get().amount() / optionalData.get().getRawFluid().amount()) * (long)k), (long)1L, (long)Math.min((long)stack3.getCount(), kegTank.getFluidCapacity() / optionalData.get().getRawFluid().amount()));
                        ItemStack outputStack = optionalData.get().getOutput().copyWithCount(itemAmount);
                        if (insertItems.stream().anyMatch(recipeItem -> recipeItem.fluidAmount > ((KegPouringRecipe)optionalData.get()).getRawFluid().amount())) continue;
                        if (insertItems.stream().anyMatch(recipeItem -> recipeItem.fluidAmount < ((KegPouringRecipe)optionalData.get()).getRawFluid().amount())) {
                            fluidToInsert = 0;
                            insertItems.clear();
                        }
                        if ((long)fluidToInsert >= fermentingRecipe.getFluidIngredient().get().amount()) continue;
                        insertItems.add(new RecipeItem(i, itemAmount, optionalData.get().getRawFluid().amount() * (long)itemAmount, optionalData.get().getContainer().copy(), outputStack));
                        fluidToInsert = (int)((long)fluidToInsert + optionalData.get().getRawFluid().amount() * (long)itemAmount);
                    }
                    long endFluidAmount = (long)fluidToInsert + (!fermentingRecipe.getFluidIngredient().get().ingredient().matches(kegTank.getAbstractedFluid()) ? 0L : kegTank.getAbstractedFluid().amount());
                    if (endFluidAmount % fermentingRecipe.getFluidIngredient().get().amount() != 0L) {
                        int itemCount = (int)(endFluidAmount / fermentingRecipe.getFluidIngredient().get().amount());
                        for (int i = 0; i < itemCount && (long)itemCount % fermentingRecipe.getFluidIngredient().get().amount() != 0L; --itemCount, ++i) {
                            insertItems.remove(insertItems.size() - 1);
                        }
                    }
                    if (!insertItems.isEmpty()) {
                        List<RecipeItem> temporaryInserts = List.copyOf(insertItems);
                        insertItems.clear();
                        for (RecipeItem insertItem2 : temporaryInserts) {
                            ((ItemStack)this.inventory.items.get(insertItem2.slot)).shrink(insertItem2.maxInsert);
                            ItemStack copiedOutput = insertItem2.output.copy();
                            List<ItemStack> inserted = blockEntity.extractInGui(insertItem2.output, insertItem2.maxInsert);
                            insertItems.addAll(inserted.stream().map(stack -> new RecipeItem(insertItem.slot, insertItem.maxInsert, insertItem.fluidAmount, copiedOutput, (ItemStack)stack)).toList());
                        }
                        if (!extractItems.isEmpty()) {
                            insertItems.addAll(extractItems);
                        }
                        insertItems.removeIf(insertItem -> insertItem.output == null || insertItem.container.isEmpty());
                        insertItems.forEach(e -> {
                            if (!this.inventory.add(((ItemStack)this.inventory.items.get(e.slot)).isEmpty() ? e.slot : this.inventory.getSlotWithRemainingSpace(e.output), e.output)) {
                                this.inventory.player.drop(e.output, false);
                            }
                        });
                        if (shouldRemoveIndex) {
                            intlist.removeInt(intlist.size() - 1);
                        }
                    }
                }
            }
            if (shouldHandleItems) {
                this.clearGrid();
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipe, (Iterator)intlist.iterator(), k);
            }
        }
        ((KegStackedContents)this.stackedContents).setIgnoreItems(false);
    }

    private record RecipeItem(int slot, int maxInsert, long fluidAmount, ItemStack container, ItemStack output) {
    }
}

