/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.particle.DrunkBubbleParticle;
import umpaz.brewinandchewin.client.particle.RagingParticle;
import umpaz.brewinandchewin.client.renderer.CoasterBlockEntityRenderer;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.client.utility.IdentifiableListener;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;
import umpaz.brewinandchewin.common.registry.BnCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BnCBlocks;
import umpaz.brewinandchewin.common.registry.BnCParticleTypes;
import vectorwing.farmersdelight.client.particle.SteamParticle;

public class BnCClientSetup {
    public static final Set<ResourceLocation> MODELS = new HashSet<ResourceLocation>();

    public static void registerBlockEntityRenderers(BiConsumer<BlockEntityType<?>, BlockEntityRendererProvider> consumer) {
        consumer.accept(BnCBlockEntityTypes.COASTER, CoasterBlockEntityRenderer::new);
    }

    public static void registerParticles(BiConsumer<ParticleType<?>, ParticleEngine.SpriteParticleRegistration> consumer) {
        consumer.accept((ParticleType<?>)BnCParticleTypes.FOG, SteamParticle.Factory::new);
        consumer.accept(BnCParticleTypes.DRUNK_BUBBLE, DrunkBubbleParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_1, RagingParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_2, RagingParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_3, RagingParticle.Factory::new);
        consumer.accept(BnCParticleTypes.RAGING_STAGE_4, RagingParticle.Factory::new);
    }

    public static void registerReloadListeners(Consumer<IdentifiableListener> consumer) {
        consumer.accept(BnCFluidItemDisplays.Loader.INSTANCE);
    }

    public static void registerColorHandlers(BiConsumer<BlockColor, Block> consumer) {
        consumer.accept((state, level, pos, pTintIndex) -> {
            BlockEntity patt0$temp;
            if (level != null && pos != null && (patt0$temp = level.getBlockEntity(pos)) instanceof CoasterBlockEntity) {
                CoasterBlockEntity blockEntity = (CoasterBlockEntity)patt0$temp;
                int tintIndex = -1;
                int count = (int)blockEntity.getItems().stream().filter(i -> !i.isEmpty()).count();
                for (int i2 = 0; i2 < count; ++i2) {
                    ItemStack stack = (ItemStack)blockEntity.getItems().get(i2);
                    ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    List<CoasterBlockEntityRenderer.ModelEntry> modelEntries = CoasterBlockEntityRenderer.getModelEntries(itemId);
                    if (modelEntries == null) continue;
                    for (CoasterBlockEntityRenderer.ModelEntry modelEntry : modelEntries) {
                        int color = -1;
                        for (int j = 0; j < modelEntry.modifiers().size(); ++j) {
                            for (TextureModifier textureModifier : modelEntry.modifiers()) {
                                color = textureModifier.color(level, state, pos, stack, color);
                            }
                        }
                        if (color == -1 || ++tintIndex != pTintIndex) continue;
                        return color;
                    }
                }
            }
            return -1;
        }, BnCBlocks.COASTER);
    }

    public static CompletableFuture<List<ResourceLocation>> getModels(ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList models = new ArrayList();
            for (Map.Entry resourceEntry : manager.listResources("brewinandchewin/coaster", fileName -> fileName.getPath().endsWith(".json")).entrySet()) {
                models.addAll(CompletableFuture.supplyAsync(() -> {
                    try {
                        BufferedReader reader = ((Resource)resourceEntry.getValue()).openAsReader();
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        ((Reader)reader).close();
                        if (json instanceof JsonObject) {
                            JsonObject jsonObject = (JsonObject)json;
                            ResourceLocation itemId = (ResourceLocation)((Pair)ResourceLocation.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("item")).getOrThrow()).getFirst();
                            List modelEntries = (List)((Pair)CoasterBlockEntityRenderer.ModelEntry.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("models")).getOrThrow()).getFirst();
                            CoasterBlockEntityRenderer.addToModelMap(itemId, modelEntries);
                            return modelEntries.stream().map(CoasterBlockEntityRenderer.ModelEntry::model).toList();
                        }
                    }
                    catch (Exception ex) {
                        BrewinAndChewin.LOG.error("Unexpected error in Brewin' And Chewin' coaster model JSON \"{}\". {}", resourceEntry.getKey(), (Object)ex);
                        return List.of();
                    }
                    BrewinAndChewin.LOG.error("Unexpected error in Brewin' And Chewin' coaster model JSON: {}.", resourceEntry.getKey());
                    return List.of();
                }, executor).join());
            }
            List<ResourceLocation> modelPaths = models.stream().filter(Objects::nonNull).toList();
            MODELS.addAll(modelPaths);
            return modelPaths;
        });
    }
}

