/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public abstract class StringDrawer {
    private static final char[] regularS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '-', '=', '(', ')'};
    private static final char[] superS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079', '\u207a', '\u207b', '\u207c', '\u207d', '\u207e'};
    private static final char[] subS = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089', '\u208a', '\u208b', '\u208c', '\u208d', '\u208e'};

    static void drawString1(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        context.drawString(client.font, text, x + 1, y + 1, color, dropShadow);
    }

    static void drawString2(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        context.drawString(client.font, text, x - client.font.width(text) / 2 - 1, y + 1, color, dropShadow);
    }

    static void drawString3(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        context.drawString(client.font, text, x - client.font.width(text) - 2, y + 1, color, dropShadow);
    }

    static void drawString4(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        Font font = client.font;
        Objects.requireNonNull(client.font);
        context.drawString(font, text, x + 1, y - 9 / 2 + 1, color, dropShadow);
    }

    static void drawString5(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        Font font = client.font;
        int n = x - client.font.width(text) / 2 - 1;
        Objects.requireNonNull(client.font);
        context.drawString(font, text, n, y - 9 / 2 + 1, color, dropShadow);
    }

    static void drawString6(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        Font font = client.font;
        int n = x - client.font.width(text) - 2;
        Objects.requireNonNull(client.font);
        context.drawString(font, text, n, y - 9 / 2 + 1, color, dropShadow);
    }

    static void drawString7(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        Font font = client.font;
        Objects.requireNonNull(client.font);
        context.drawString(font, text, x + 1, y - 9 + 1, color, dropShadow);
    }

    static void drawString8(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        Font font = client.font;
        int n = x - client.font.width(text) / 2 - 1;
        Objects.requireNonNull(client.font);
        context.drawString(font, text, n, y - 9 + 1, color, dropShadow);
    }

    static void drawString9(GuiGraphics context, Minecraft client, @Nullable String text, int x, int y, int color, boolean dropShadow) {
        Font font = client.font;
        int n = x - client.font.width(text) - 2;
        Objects.requireNonNull(client.font);
        context.drawString(font, text, n, y - 9 + 1, color, dropShadow);
    }

    static String toSuperScript(String s) {
        for (int i = 0; i < 15; ++i) {
            s = s.replace(regularS[i], superS[i]);
        }
        return s;
    }

    static String toSubScript(String s) {
        for (int i = 0; i < 15; ++i) {
            s = s.replace(regularS[i], subS[i]);
        }
        return s;
    }
}

