/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.common.component.MusicLabelComponent;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.menu.UrlMenu;
import gg.moonflower.etched.common.network.play.ServerboundEditMusicLabelPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.common.network.play.SetUrlPacket;
import gg.moonflower.etched.core.registry.EtchedComponents;
import gg.moonflower.etched.core.registry.EtchedItems;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedServerPlayPacketHandler {
    public static void handleSetUrl(SetUrlPacket pkt, IPayloadContext ctx) {
        Player player = ctx.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof UrlMenu) {
            UrlMenu menu = (UrlMenu)abstractContainerMenu;
            menu.setUrl(pkt.url());
        }
    }

    public static void handleEditMusicLabel(ServerboundEditMusicLabelPacket pkt, IPayloadContext ctx) {
        int slot = pkt.slot();
        if (!Inventory.isHotbarSlot((int)slot) && slot != 40) {
            return;
        }
        Player player = ctx.player();
        ItemStack labelStack = player.getInventory().getItem(slot);
        if (!labelStack.is((Item)EtchedItems.MUSIC_LABEL.get())) {
            return;
        }
        labelStack.update(EtchedComponents.MUSIC_LABEL, (Object)MusicLabelComponent.DEFAULT, label -> label.withInfo(StringUtils.normalizeSpace((String)pkt.artist()), StringUtils.normalizeSpace((String)pkt.title())));
    }

    public static void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, IPayloadContext ctx) {
        ServerLevel level;
        AlbumJukeboxMenu menu;
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
        if (abstractContainerMenu instanceof AlbumJukeboxMenu && (menu = (AlbumJukeboxMenu)abstractContainerMenu).setPlayingTrack((Level)(level = player2.serverLevel()), pkt)) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)new ChunkPos(menu.getPos()), (CustomPacketPayload)new SetAlbumJukeboxTrackPacket(pkt.playingIndex(), pkt.track()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

