/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.common.component.PausedComponent;
import gg.moonflower.etched.common.component.PlayingRecordComponent;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.BoomboxMenu;
import gg.moonflower.etched.core.Etched;
import gg.moonflower.etched.core.registry.EtchedComponents;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends Item
implements ContainerItem {
    private static final Map<Integer, ItemStack> PLAYING_RECORDS = new Int2ObjectArrayMap();
    private static final Component PAUSE = Component.translatable((String)"item.etched.boombox.pause", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use")}).withStyle(ChatFormatting.GRAY);

    public BoomboxItem(Item.Properties properties) {
        super(properties);
    }

    public static void onLivingEntityUpdateClient(LivingEntity entity) {
        Player player;
        ItemStack newPlayingRecord = ItemStack.EMPTY;
        if (entity instanceof Player) {
            ItemStack carried;
            player = (Player)entity;
            if (Minecraft.getInstance().cameraEntity == entity && BoomboxItem.hasRecord(carried = player.inventoryMenu.getCarried()) && !carried.has(EtchedComponents.PAUSED)) {
                newPlayingRecord = BoomboxItem.getRecord(carried);
            }
        }
        if (newPlayingRecord.isEmpty()) {
            for (Player hand : InteractionHand.values()) {
                ItemStack stack = entity.getItemInHand((InteractionHand)hand);
                if (!BoomboxItem.hasRecord(stack) || stack.has(EtchedComponents.PAUSED)) continue;
                newPlayingRecord = BoomboxItem.getRecord(stack);
                break;
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (newPlayingRecord.isEmpty() && Minecraft.getInstance().cameraEntity == entity) {
                for (ItemStack stack : player.getInventory().items) {
                    if (!BoomboxItem.hasRecord(stack) || stack.has(EtchedComponents.PAUSED)) continue;
                    newPlayingRecord = BoomboxItem.getRecord(stack);
                    break;
                }
            }
        }
        BoomboxItem.updatePlaying((Entity)entity, newPlayingRecord);
    }

    private static void updatePlaying(Entity entity, ItemStack record) {
        if (!ItemStack.matches((ItemStack)PLAYING_RECORDS.getOrDefault(entity.getId(), ItemStack.EMPTY), (ItemStack)record)) {
            SoundTracker.playBoombox(entity.getId(), record);
            if (record.isEmpty()) {
                PLAYING_RECORDS.remove(entity.getId());
            } else {
                PLAYING_RECORDS.put(entity.getId(), record);
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.level().isClientSide()) {
            return false;
        }
        BoomboxItem.updatePlaying((Entity)entity, !stack.has(EtchedComponents.PAUSED) ? BoomboxItem.getRecord(stack) : ItemStack.EMPTY);
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive()) {
            if (stack.has(EtchedComponents.PAUSED)) {
                stack.remove(EtchedComponents.PAUSED);
            } else {
                stack.set(EtchedComponents.PAUSED, (Object)PausedComponent.INSTANCE);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        if (!((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public AbstractContainerMenu constructMenu(int containerId, Inventory inventory, Player player, int index) {
        return new BoomboxMenu(containerId, inventory, index);
    }

    public boolean overrideStackedOnOther(ItemStack boombox, Slot slot, ClickAction clickAction, Player player) {
        if (((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack clickItem = slot.getItem();
        if (clickItem.isEmpty()) {
            ItemStack record = BoomboxItem.getRecord(boombox);
            if (!record.isEmpty()) {
                player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                BoomboxItem.setRecord(boombox, slot.safeInsert(record));
                return true;
            }
        } else if (PlayableRecord.isPlayableRecord(clickItem)) {
            player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
            ItemStack old = BoomboxItem.getRecord(boombox);
            BoomboxItem.setRecord(boombox, slot.safeTake(clickItem.getCount(), 1, player).split(1));
            slot.set(old);
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack boombox, ItemStack clickItem, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (((Boolean)Etched.SERVER_CONFIG.useBoomboxMenu.get()).booleanValue()) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        if (slot.allowModification(player)) {
            ItemStack old;
            if (clickItem.isEmpty()) {
                ItemStack record = BoomboxItem.getRecord(boombox);
                if (!record.isEmpty()) {
                    player.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                    slotAccess.set(record);
                    BoomboxItem.setRecord(boombox, ItemStack.EMPTY);
                    return true;
                }
            } else if (PlayableRecord.isPlayableRecord(clickItem) && ((old = BoomboxItem.getRecord(boombox)).isEmpty() || clickItem.getCount() == 1)) {
                player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                BoomboxItem.setRecord(boombox, clickItem.split(1));
                slotAccess.set(old);
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(PAUSE);
    }

    @Nullable
    public static InteractionHand getPlayingHand(LivingEntity entity) {
        if (!PLAYING_RECORDS.containsKey(entity.getId())) {
            return null;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = entity.getItemInHand(hand);
            if (!BoomboxItem.hasRecord(stack) || stack.has(EtchedComponents.PAUSED)) continue;
            return hand;
        }
        return null;
    }

    public static boolean hasRecord(ItemStack stack) {
        return stack.has(EtchedComponents.PLAYING_RECORD);
    }

    public static ItemStack getRecord(ItemStack stack) {
        PlayingRecordComponent record = (PlayingRecordComponent)stack.get(EtchedComponents.PLAYING_RECORD);
        return record != null ? record.stack() : ItemStack.EMPTY;
    }

    public static void setRecord(ItemStack stack, ItemStack record) {
        if (record.isEmpty()) {
            stack.remove(EtchedComponents.PLAYING_RECORD);
        } else {
            stack.set(EtchedComponents.PLAYING_RECORD, (Object)new PlayingRecordComponent(record.copyWithCount(1)));
        }
    }
}

