/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.core.registry.EtchedComponents;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class AlbumCoverComponent
implements TooltipProvider {
    public static final Codec<AlbumCoverComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.optionalEmptyMap((Codec)ItemStack.SINGLE_ITEM_CODEC).xmap(stack -> stack.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack)).listOf(0, 9).fieldOf("items").forGetter(AlbumCoverComponent::getItems), (App)ItemStack.OPTIONAL_CODEC.fieldOf("coverStack").forGetter(AlbumCoverComponent::getCoverStack)).apply((Applicative)instance, AlbumCoverComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AlbumCoverComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)9)), AlbumCoverComponent::getItems, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, AlbumCoverComponent::getCoverStack, AlbumCoverComponent::new);
    public static final int MAX_RECORDS = 9;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final List<ItemStack> itemsView;
    private final ItemStack coverStack;

    private AlbumCoverComponent(List<ItemStack> items, ItemStack coverStack) {
        for (int i = 0; i < Math.min(this.items.size(), items.size()); ++i) {
            ItemStack stack = items.get(i);
            if (stack == null || stack.isEmpty()) continue;
            this.items.set(i, (Object)stack);
        }
        this.itemsView = Collections.unmodifiableList(this.items);
        this.coverStack = coverStack;
        if (!this.coverStack.isEmpty()) {
            this.coverStack.setCount(1);
        }
    }

    public ItemStack getRecord(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
    }

    public ItemStack getCoverStack() {
        return this.coverStack;
    }

    public List<ItemStack> getItems() {
        return this.itemsView;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ItemStack stack) {
        AlbumCoverComponent component = (AlbumCoverComponent)stack.get(EtchedComponents.ALBUM_COVER);
        Builder builder = component != null ? component.toBuilder() : AlbumCoverComponent.builder();
        return builder;
    }

    public static boolean isValid(ItemStack stack) {
        return PlayableRecord.isPlayableRecord(stack) && !stack.has(EtchedComponents.ALBUM_COVER);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlbumCoverComponent component = (AlbumCoverComponent)o;
        return ItemStack.listMatches(this.items, component.items) && ItemStack.matches((ItemStack)this.coverStack, (ItemStack)component.coverStack);
    }

    public int hashCode() {
        int result = 0;
        for (ItemStack record : this.items) {
            if (record.isEmpty()) continue;
            result = result * 31 + ItemStack.hashItemAndComponents((ItemStack)record);
        }
        result = 31 * result + ItemStack.hashItemAndComponents((ItemStack)this.coverStack);
        return result;
    }

    public String toString() {
        return "AlbumCoverComponent[items=" + String.valueOf(this.items) + ", coverStack=" + String.valueOf(this.coverStack) + "]";
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        for (ItemStack record : this.items) {
            if (record.isEmpty()) continue;
            record.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, context, tooltipAdder, tooltipFlag);
            PlayableRecord.addToTooltip(record, context, tooltipAdder);
        }
    }

    public static class Builder
    implements Container {
        private final NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        private ItemStack coverStack = ItemStack.EMPTY;
        private boolean coverStackSet;

        public Builder() {
        }

        private Builder(AlbumCoverComponent component) {
            this();
            for (int i = 0; i < 9; ++i) {
                this.items.set(i, (Object)((ItemStack)component.items.get(i)));
            }
            this.coverStack = component.coverStack;
        }

        private void updateCover(ItemStack stack) {
            if (!stack.isEmpty() && !this.coverStackSet && this.coverStack.isEmpty()) {
                this.coverStack = stack;
            }
        }

        public ItemStack insert(ItemStack insert) {
            if (insert.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack copy = insert.copy();
            for (int i = 0; i < this.items.size(); ++i) {
                if (!this.canPlaceItem(i, copy)) continue;
                ItemStack stack = (ItemStack)this.items.get(i);
                int split = Math.min(copy.getCount(), this.getMaxStackSize(copy) - stack.getCount());
                if (split <= 0) continue;
                if (stack.isEmpty()) {
                    this.items.set(i, (Object)copy.split(split));
                    this.updateCover((ItemStack)this.items.get(i));
                } else if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)copy)) {
                    copy.shrink(split);
                    stack.grow(split);
                    this.updateCover(stack);
                }
                if (!copy.isEmpty()) continue;
                return ItemStack.EMPTY;
            }
            return copy;
        }

        public ItemStack extract(Container inventory) {
            for (int i = this.items.size() - 1; i >= 0; --i) {
                ItemStack stack = (ItemStack)this.items.get(i);
                if (!this.canTakeItem(inventory, i, stack) || stack.isEmpty()) continue;
                return this.removeItem(i, stack.getMaxStackSize());
            }
            return ItemStack.EMPTY;
        }

        public int getMaxStackSize() {
            return 1;
        }

        public int getMaxStackSize(ItemStack stack) {
            return Math.min(this.getMaxStackSize(), stack.getMaxStackSize());
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return AlbumCoverComponent.isValid(stack);
        }

        public int getContainerSize() {
            return this.items.size();
        }

        public boolean isEmpty() {
            for (ItemStack stack : this.items) {
                if (stack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int slot) {
            return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
        }

        public ItemStack removeItem(int slot, int amount) {
            return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        }

        public ItemStack removeItemNoUpdate(int slot) {
            ItemStack stack = this.getItem(slot);
            if (!stack.isEmpty()) {
                this.items.set(slot, (Object)ItemStack.EMPTY);
            }
            return stack;
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= 0 && slot < this.items.size()) {
                this.items.set(slot, (Object)stack);
                this.updateCover(stack);
            }
        }

        public void setChanged() {
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void clearContent() {
            this.items.clear();
        }

        public Builder setCoverStack(ItemStack coverStack) {
            this.coverStack = coverStack;
            this.coverStackSet = true;
            return this;
        }

        public AlbumCoverComponent build() {
            return new AlbumCoverComponent((List<ItemStack>)this.items, this.coverStack.copyWithCount(1));
        }
    }
}

