/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.download;

import com.google.gson.JsonParseException;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import java.io.IOException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public interface SoundDownloadSource {
    public static final Component RESOLVING_TRACKS = Component.translatable((String)"record.etched.resolvingTracks");

    public static Map<String, String> getDownloadHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        WorldVersion version = SharedConstants.getCurrentVersion();
        map.put("X-Minecraft-Version", version.getName());
        map.put("X-Minecraft-Version-ID", version.getId());
        map.put("X-Minecraft-Pack-Format", String.valueOf(version.getPackVersion(PackType.CLIENT_RESOURCES)));
        map.put("User-Agent", "Minecraft Java/" + version.getName());
        return map;
    }

    public Collection<URL> resolveUrl(String var1, @Nullable DownloadProgressListener var2, Proxy var3) throws IOException, URISyntaxException, JsonParseException;

    public Collection<TrackData> resolveTracks(String var1, @Nullable DownloadProgressListener var2, Proxy var3) throws IOException, URISyntaxException, JsonParseException;

    public Optional<String> resolveAlbumCover(String var1, @Nullable DownloadProgressListener var2, Proxy var3, ResourceManager var4) throws IOException, URISyntaxException, JsonParseException;

    public boolean isValidUrl(String var1);

    public boolean isTemporary(String var1);

    public String getApiName();

    default public Optional<Component> getBrandText(String url) {
        return Optional.empty();
    }
}

