/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardScreen;
import com.refinedmods.refinedstorage.common.security.PlayerBoundSecurityCardData;
import com.refinedmods.refinedstorage.common.security.SecurityCardContainerMenu;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class SecurityCardScreen
extends AbstractSecurityCardScreen<SecurityCardContainerMenu> {
    private static final int BOUND_PLAYER_BUTTON_RIGHT_PADDING = 6;
    private static final int BOUND_PLAYER_BUTTON_WIDTH = 80;

    public SecurityCardScreen(SecurityCardContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    @Override
    protected void init(int rows) {
        super.init(rows);
        MutableComponent boundToText = Component.literal((String)((SecurityCardContainerMenu)this.menu).getBoundTo().name());
        Button boundPlayerButton = Button.builder((Component)boundToText, this::toggleBoundPlayer).pos(this.leftPos + this.imageWidth - 6 - 80, this.topPos + 4).size(80, 14).build();
        this.addRenderableWidget((GuiEventListener)boundPlayerButton);
    }

    private void toggleBoundPlayer(Button button) {
        if (((SecurityCardContainerMenu)this.menu).getPlayers().isEmpty()) {
            return;
        }
        PlayerBoundSecurityCardData.Player currentPlayer = ((SecurityCardContainerMenu)this.menu).getBoundTo();
        int index = ((SecurityCardContainerMenu)this.menu).getPlayers().indexOf(currentPlayer);
        int nextIndex = (index + 1) % ((SecurityCardContainerMenu)this.menu).getPlayers().size();
        PlayerBoundSecurityCardData.Player nextPlayer = ((SecurityCardContainerMenu)this.menu).getPlayers().get(nextIndex);
        ((SecurityCardContainerMenu)this.menu).changeBoundPlayer(nextPlayer);
        button.setMessage((Component)Component.literal((String)nextPlayer.name()));
    }
}

