/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

record NetworkReceiverKey(GlobalPos pos) {
    int getDistance(BlockPos from) {
        return (int)Math.sqrt(Math.pow((double)from.getX() - (double)this.pos.pos().getX(), 2.0) + Math.pow((double)from.getY() - (double)this.pos.pos().getY(), 2.0) + Math.pow((double)from.getZ() - (double)this.pos.pos().getZ(), 2.0));
    }

    MutableComponent getDimensionName() {
        return NetworkReceiverKey.getDimensionName((ResourceKey<Level>)this.pos.dimension());
    }

    static MutableComponent getDimensionName(ResourceKey<Level> dimension) {
        if (dimension == Level.OVERWORLD) {
            return Component.literal((String)"Overworld");
        }
        if (dimension == Level.END) {
            return Component.literal((String)"The End");
        }
        if (dimension == Level.NETHER) {
            return Component.literal((String)"The Nether");
        }
        return Component.translatable((String)"dimension.%s.%s".formatted(dimension.location().getNamespace(), dimension.location().getPath()));
    }
}

