/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan.IndustrialFanBE;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class IndustrialFanRenderer
extends KineticBlockEntityRenderer<IndustrialFanBE> {
    public IndustrialFanRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(IndustrialFanBE be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        Direction direction = (Direction)be.getBlockState().getValue((Property)BlockStateProperties.FACING);
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        int lightOverall = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)be.getBlockPos());
        int lightInFront = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)be.getBlockPos().relative(direction));
        SuperByteBuffer cog = CachedBuffers.partialFacing((PartialModel)DesiresPartialModels.INDUSTRIAL_FAN_POWER, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        SuperByteBuffer fanInner = CachedBuffers.partialFacing((PartialModel)DesiresPartialModels.INDUSTRIAL_FAN_INNER, (BlockState)be.getBlockState(), (Direction)direction.getOpposite());
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float speed = be.getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.clamp((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.clamp((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        float angle = time * speed * 3.0f / 10.0f % 360.0f;
        angle = angle / 180.0f * (float)Math.PI;
        IndustrialFanRenderer.standardKineticRotationTransform((SuperByteBuffer)cog, (KineticBlockEntity)be, (int)lightOverall).renderInto(ms, vb);
        IndustrialFanRenderer.kineticRotationTransform((SuperByteBuffer)fanInner, (KineticBlockEntity)be, (Direction.Axis)direction.getAxis(), (float)angle, (int)lightInFront).renderInto(ms, vb);
    }
}

