/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record MultiblockLevel(Supplier<Level> getLevel, MultiblockOrientation orientation, Supplier<BlockPos> origin) implements IMultiblockLevel
{
    public MultiblockLevel(Supplier<Level> getLevel, MultiblockOrientation orientation, BlockPos origin) {
        this(getLevel, orientation, () -> origin);
    }

    @Override
    public BlockState getBlockState(BlockPos relativePosition) {
        return SafeChunkUtils.getBlockState((LevelAccessor)this.level(), this.toAbsolute(relativePosition));
    }

    @Override
    public void setBlock(BlockPos relativePosition, BlockState state) {
        this.level().setBlock(this.toAbsolute(relativePosition), state, 3);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos relativePosition) {
        return SafeChunkUtils.getSafeBE((LevelAccessor)this.level(), this.toAbsolute(relativePosition));
    }

    @Override
    @Nullable
    public BlockEntity forciblyGetBlockEntity(BlockPos relativePosition) {
        return this.level().getBlockEntity(this.toAbsolute(relativePosition));
    }

    @Override
    public boolean shouldTickModulo(int interval) {
        int posRandom = Integer.MAX_VALUE & this.origin.hashCode();
        return (long)(posRandom % interval) == this.level().getGameTime() % (long)interval;
    }

    @Override
    public BlockPos getAbsoluteOrigin() {
        return this.origin.get();
    }

    @Override
    public MultiblockOrientation getOrientation() {
        return this.orientation;
    }

    @Override
    public BlockPos toAbsolute(BlockPos relative) {
        return this.getAbsoluteOrigin().offset((Vec3i)this.orientation.getAbsoluteOffset(relative));
    }

    @Override
    @Nullable
    public Direction toAbsolute(@Nullable RelativeBlockFace relative) {
        if (relative != null) {
            return relative.forFront(this.orientation);
        }
        return null;
    }

    @Override
    public AABB toAbsolute(AABB relative) {
        Vec3 minPos = new Vec3(relative.minX, relative.minY, relative.minZ);
        Vec3 maxPos = new Vec3(relative.maxX, relative.maxY, relative.maxZ);
        return new AABB(this.toAbsolute(minPos), this.toAbsolute(maxPos));
    }

    @Override
    public Vec3 toAbsolute(Vec3 relative) {
        return Vec3.atLowerCornerOf((Vec3i)this.getAbsoluteOrigin()).add(this.orientation.getAbsoluteOffset(relative));
    }

    @Override
    public BlockPos toRelative(BlockPos absolute) {
        BlockPos absoluteOffset = absolute.subtract((Vec3i)this.getAbsoluteOrigin());
        return this.orientation.getPosInMB(absoluteOffset);
    }

    @Override
    public RelativeBlockFace toRelative(Direction absolute) {
        return RelativeBlockFace.from(this.orientation, absolute);
    }

    @Override
    public boolean isThundering() {
        return this.level().isThundering();
    }

    @Override
    public boolean isRaining() {
        return this.level().isRaining();
    }

    @Override
    public int getMaxBuildHeight() {
        return this.level().getMaxBuildHeight();
    }

    @Override
    public Level getRawLevel() {
        return this.level();
    }

    @Override
    public void updateNeighbourForOutputSignal(BlockPos posInMultiblock) {
        BlockPos absolutePos = this.toAbsolute(posInMultiblock);
        if (!SafeChunkUtils.isChunkSafe((LevelAccessor)this.level(), absolutePos)) {
            return;
        }
        BlockState stateAt = this.level().getBlockState(absolutePos);
        this.level().updateNeighbourForOutputSignal(absolutePos, stateAt.getBlock());
    }

    private Level level() {
        return Objects.requireNonNull(this.getLevel.get());
    }
}

