/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;

public class TeslaCoilBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IScrewdriverInteraction,
IModelOffsetProvider {
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(48000);
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, TeslaCoilBlockEntity::master, this.makeEnergyInput(this.energyStorage));
    public boolean redstoneControlInverted = false;
    public boolean lowPower = false;
    public final List<LightningAnimation> effectMap = new ArrayList<LightningAnimation>();
    private static final IElectricEquipment.ElectricSource TC_FIELD = new IElectricEquipment.ElectricSource(-1.0f);
    public AABB renderBB;

    public TeslaCoilBlockEntity(BlockEntityType<TeslaCoilBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickClient() {
        this.effectMap.removeIf(LightningAnimation::tick);
    }

    @Override
    public void tickServer() {
        int timeKey = this.getBlockPos().getX() ^ this.getBlockPos().getZ();
        int energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption.get();
        if (this.lowPower) {
            energyDrain /= 2;
        }
        if (this.level.getGameTime() % 32L == (long)(timeKey & 0x1F) && this.canRun(energyDrain)) {
            this.energyStorage.extractEnergy(energyDrain, false);
            double radius = 6.0;
            if (this.lowPower) {
                radius /= 2.0;
            }
            AABB aabbSmall = new AABB((double)this.getBlockPos().getX() + 0.5 - radius, (double)this.getBlockPos().getY() + 0.5 - radius, (double)this.getBlockPos().getZ() + 0.5 - radius, (double)this.getBlockPos().getX() + 0.5 + radius, (double)this.getBlockPos().getY() + 0.5 + radius, (double)this.getBlockPos().getZ() + 0.5 + radius);
            AABB aabb = aabbSmall.inflate(radius / 2.0);
            List targetsAll = this.level.getEntitiesOfClass(Entity.class, aabb);
            List targets = targetsAll.stream().filter(e -> e instanceof LivingEntity && aabbSmall.intersects(e.getBoundingBox())).collect(Collectors.toList());
            LivingEntity target = null;
            if (!targets.isEmpty()) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(this.level, ((Double)IEServerConfig.MACHINES.teslacoil_damage.get()).floatValue(), this.lowPower);
                int randomTarget = ApiUtils.RANDOM.nextInt(targets.size());
                target = (LivingEntity)targets.get(randomTarget);
                if (target != null && !this.level.isClientSide) {
                    energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption_active.get();
                    if (this.lowPower) {
                        energyDrain /= 2;
                    }
                    if (this.energyStorage.extractEnergy(energyDrain, true) == energyDrain) {
                        this.energyStorage.extractEnergy(energyDrain, false);
                        target.addEffect(new MobEffectInstance(IEPotions.STUNNED, 128));
                        if (dmgsrc.apply((Entity)target)) {
                            int prevFire = target.getRemainingFireTicks();
                            target.setRemainingFireTicks(1);
                            target.setRemainingFireTicks(prevFire);
                        }
                        this.sendRenderPacket((Entity)target);
                    }
                }
            }
            for (Entity e2 : targetsAll) {
                if (e2 == target) continue;
                if (e2 instanceof ITeslaEntity) {
                    ((ITeslaEntity)e2).onHit(this, this.lowPower);
                    continue;
                }
                if (!(e2 instanceof LivingEntity)) continue;
                IElectricEquipment.applyToEntity((LivingEntity)e2, null, TC_FIELD);
            }
            if (targets.isEmpty() && this.level.getGameTime() % 128L == (long)(timeKey & 0x7F)) {
                BlockState state;
                VoxelShape shape;
                double tV = (ApiUtils.RANDOM.nextDouble() - 0.5) * 8.0;
                double tH = (ApiUtils.RANDOM.nextDouble() - 0.5) * 8.0;
                if (this.lowPower) {
                    tV /= 2.0;
                    tH /= 2.0;
                }
                BlockPos targetBlock = this.getBlockPos().offset((int)(this.getFacing().getAxis() == Direction.Axis.X ? 0.0 : (tH += tH < 0.0 ? -2.0 : 2.0)), (int)(this.getFacing().getAxis() == Direction.Axis.Y ? 0.0 : (tV += tV < 0.0 ? -2.0 : 2.0)), (int)(this.getFacing().getAxis() == Direction.Axis.Y ? tV : (this.getFacing().getAxis() == Direction.Axis.X ? tH : 0.0)));
                double tL = 0.0;
                boolean targetFound = false;
                if (!this.level.isEmptyBlock(targetBlock) && !(shape = (state = this.level.getBlockState(targetBlock)).getShape((BlockGetter)this.level, targetBlock)).isEmpty()) {
                    AABB blockBounds = shape.bounds();
                    tL = this.getFacing() == Direction.UP ? (double)(targetBlock.getY() - this.getBlockPos().getY()) + blockBounds.maxY : (this.getFacing() == Direction.DOWN ? (double)(targetBlock.getY() - this.getBlockPos().getY()) + blockBounds.minY : (this.getFacing() == Direction.NORTH ? (double)(targetBlock.getZ() - this.getBlockPos().getZ()) + blockBounds.minZ : (this.getFacing() == Direction.SOUTH ? (double)(targetBlock.getZ() - this.getBlockPos().getZ()) + blockBounds.maxZ : (this.getFacing() == Direction.WEST ? (double)(targetBlock.getX() - this.getBlockPos().getX()) + blockBounds.minX : (double)(targetBlock.getX() - this.getBlockPos().getX()) + blockBounds.maxX))));
                    targetFound = true;
                }
                if (!targetFound) {
                    boolean positiveFirst = ApiUtils.RANDOM.nextBoolean();
                    for (int i = 0; i < 2; ++i) {
                        for (int ll = 0; ll <= 6; ++ll) {
                            Direction tempF;
                            BlockState state2;
                            VoxelShape shape2;
                            BlockPos targetBlock2 = targetBlock.relative(positiveFirst ? this.getFacing() : this.getFacing().getOpposite(), ll);
                            if (this.level.isEmptyBlock(targetBlock2) || (shape2 = (state2 = this.level.getBlockState(targetBlock2)).getShape((BlockGetter)this.level, targetBlock2)).isEmpty()) continue;
                            AABB blockBounds = shape2.bounds();
                            tL = this.getFacing().getAxis() == Direction.Axis.Y ? (double)(targetBlock2.getY() - this.getBlockPos().getY()) : (this.getFacing().getAxis() == Direction.Axis.Z ? (double)(targetBlock2.getZ() - this.getBlockPos().getZ()) : (double)(targetBlock2.getZ() - this.getBlockPos().getZ()));
                            Direction direction = tempF = positiveFirst ? this.getFacing() : this.getFacing().getOpposite();
                            tL = tempF == Direction.UP ? (tL += blockBounds.maxY) : (tempF == Direction.DOWN ? (tL += blockBounds.minY) : (tempF == Direction.NORTH ? (tL += blockBounds.minZ) : (tempF == Direction.SOUTH ? (tL += blockBounds.maxZ) : (tempF == Direction.WEST ? (tL += blockBounds.minX) : (tL += blockBounds.maxX)))));
                            targetFound = true;
                            break;
                        }
                        if (targetFound) break;
                        positiveFirst = !positiveFirst;
                    }
                }
                if (targetFound) {
                    this.sendFreePacket(tL, tH, tV);
                }
            }
            this.setChanged();
        }
    }

    protected void sendRenderPacket(Entity target) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("targetEntity", target.getId());
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new MessageBlockEntitySync(this.getBlockPos(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void sendFreePacket(double tL, double tH, double tV) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("tL", tL);
        tag.putDouble("tV", tV);
        tag.putDouble("tH", tH);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new MessageBlockEntitySync(this.getBlockPos(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        if (message.contains("targetEntity", 3)) {
            Entity target = this.level.getEntity(message.getInt("targetEntity"));
            if (target instanceof LivingEntity) {
                double dx = target.getX() - (double)this.getBlockPos().getX();
                double dy = target.getY() - (double)this.getBlockPos().getY();
                double dz = target.getZ() - (double)this.getBlockPos().getZ();
                Direction f = this.getFacing().getAxis() == Direction.Axis.Y ? (Math.abs(dz) > Math.abs(dx) ? (dz < 0.0 ? Direction.NORTH : Direction.SOUTH) : (dx < 0.0 ? Direction.WEST : Direction.EAST)) : (this.getFacing().getAxis() == Direction.Axis.Z ? (Math.abs(dy) > Math.abs(dx) ? (dy < 0.0 ? Direction.DOWN : Direction.UP) : (dx < 0.0 ? Direction.WEST : Direction.EAST)) : (Math.abs(dy) > Math.abs(dz) ? (dy < 0.0 ? Direction.DOWN : Direction.UP) : (dz < 0.0 ? Direction.NORTH : Direction.SOUTH)));
                double verticalOffset = 1.0 + ApiUtils.RANDOM.nextDouble() * 0.25;
                Vec3 coilPos = Vec3.atCenterOf((Vec3i)this.getBlockPos());
                coilPos = coilPos.add((double)this.getFacing().getStepX() * verticalOffset, (double)this.getFacing().getStepY() * verticalOffset, (double)this.getFacing().getStepZ() * verticalOffset);
                if (f != null) {
                    coilPos = coilPos.add((double)f.getStepX() * 0.375, (double)f.getStepY() * 0.375, (double)f.getStepZ() * 0.375);
                    f = DirectionUtils.rotateAround(f, this.getFacing().getAxis());
                    double dShift = (ApiUtils.RANDOM.nextDouble() - 0.5) * 0.75;
                    coilPos = coilPos.add((double)f.getStepX() * dShift, (double)f.getStepY() * dShift, (double)f.getStepZ() * dShift);
                }
                this.addAnimation(new LightningAnimation(coilPos, (LivingEntity)target));
                this.level.playLocalSound(coilPos.x, coilPos.y, coilPos.z, (SoundEvent)IESounds.tesla.value(), SoundSource.BLOCKS, 2.5f, 0.5f + ApiUtils.RANDOM.nextFloat(), true);
            }
        } else if (message.contains("tL", 6)) {
            this.initFreeStreamer(message.getDouble("tL"), message.getDouble("tV"), message.getDouble("tH"));
        }
    }

    public void initFreeStreamer(double tL, double tV, double tH) {
        double ty;
        double tx = this.getFacing().getAxis() == Direction.Axis.X ? tL : tH;
        double d = ty = this.getFacing().getAxis() == Direction.Axis.Y ? tL : tV;
        double tz = this.getFacing().getAxis() == Direction.Axis.Y ? tV : (this.getFacing().getAxis() == Direction.Axis.X ? tH : tL);
        Direction f = null;
        f = this.getFacing().getAxis() == Direction.Axis.Y ? (Math.abs(tz) > Math.abs(tx) ? (tz < 0.0 ? Direction.NORTH : Direction.SOUTH) : (tx < 0.0 ? Direction.WEST : Direction.EAST)) : (this.getFacing().getAxis() == Direction.Axis.Z ? (Math.abs(ty) > Math.abs(tx) ? (ty < 0.0 ? Direction.DOWN : Direction.UP) : (tx < 0.0 ? Direction.WEST : Direction.EAST)) : (Math.abs(ty) > Math.abs(tz) ? (ty < 0.0 ? Direction.DOWN : Direction.UP) : (tz < 0.0 ? Direction.NORTH : Direction.SOUTH)));
        double verticalOffset = 1.0 + ApiUtils.RANDOM.nextDouble() * 0.25;
        Vec3 coilPos = Vec3.atCenterOf((Vec3i)this.getBlockPos());
        coilPos = coilPos.add((double)this.getFacing().getStepX() * verticalOffset, (double)this.getFacing().getStepY() * verticalOffset, (double)this.getFacing().getStepZ() * verticalOffset);
        coilPos = coilPos.add((double)f.getStepX() * 0.375, (double)f.getStepY() * 0.375, (double)f.getStepZ() * 0.375);
        f = DirectionUtils.rotateAround(f, this.getFacing().getAxis());
        double dShift = (ApiUtils.RANDOM.nextDouble() - 0.5) * 0.75;
        coilPos = coilPos.add((double)f.getStepX() * dShift, (double)f.getStepY() * dShift, (double)f.getStepZ() * dShift);
        this.addAnimation(new LightningAnimation(coilPos, Vec3.atLowerCornerOf((Vec3i)this.getBlockPos()).add(tx, ty, tz)));
        this.level.playLocalSound((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)IESounds.tesla.value(), SoundSource.BLOCKS, 2.5f, 0.5f + ApiUtils.RANDOM.nextFloat(), true);
    }

    private void addAnimation(LightningAnimation ani) {
        Minecraft.getInstance().submitAsync(() -> this.effectMap.add(ani));
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.redstoneControlInverted = nbt.getBoolean("redstoneInverted");
        this.lowPower = nbt.getBoolean("lowPower");
        EnergyHelper.deserializeFrom(this.energyStorage, nbt, provider);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putBoolean("redstoneInverted", this.redstoneControlInverted);
        nbt.putBoolean("lowPower", this.lowPower);
        EnergyHelper.serializeTo(this.energyStorage, nbt, provider);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (!this.isDummy()) {
            return Shapes.block();
        }
        switch (this.getFacing()) {
            case DOWN: {
                return Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)1.0, (double)0.875);
            }
            case UP: {
                return Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
            case NORTH: {
                return Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)1.0);
            }
            case SOUTH: {
                return Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.875);
            }
            case WEST: {
                return Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875);
            }
            case EAST: {
                return Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
            }
        }
        return Shapes.block();
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.isDummy()) {
            BlockEntity te = this.level.getBlockEntity(this.getBlockPos().relative(this.getFacing(), -1));
            if (te instanceof TeslaCoilBlockEntity) {
                return ((TeslaCoilBlockEntity)te).screwdriverUseSide(side, player, hand, hitVec);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.level.isClientSide) {
            if (player.isShiftKeyDown()) {
                int energyDrain = (Integer)IEServerConfig.MACHINES.teslacoil_consumption.get();
                if (this.lowPower) {
                    energyDrain /= 2;
                }
                if (this.canRun(energyDrain)) {
                    player.hurt(IEDamageSources.causeTeslaPrimaryDamage(this.level), Float.MAX_VALUE);
                } else {
                    this.lowPower = !this.lowPower;
                    player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.tesla." + (this.lowPower ? "lowPower" : "highPower"))), true);
                    this.setChanged();
                }
            } else {
                this.redstoneControlInverted = !this.redstoneControlInverted;
                player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"))), true);
                this.setChanged();
                this.markContainingBlockForUpdate(null);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    @Nullable
    public TeslaCoilBlockEntity master() {
        TeslaCoilBlockEntity tc;
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.getBlockPos().below();
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof TeslaCoilBlockEntity ? (tc = (TeslaCoilBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        this.level.setBlockAndUpdate(this.worldPosition.relative(this.getFacing()), (BlockState)state.setValue((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)));
        ((TeslaCoilBlockEntity)this.level.getBlockEntity(this.worldPosition.relative(this.getFacing()))).setFacing(this.getFacing());
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        boolean dummy = this.isDummy();
        for (int i = 0; i <= 1; ++i) {
            if (!(this.level.getBlockEntity(this.getBlockPos().relative(this.getFacing(), dummy ? -1 : 0).relative(this.getFacing(), i)) instanceof TeslaCoilBlockEntity)) continue;
            this.level.removeBlock(this.getBlockPos().relative(this.getFacing(), dummy ? -1 : 0).relative(this.getFacing(), i), false);
        }
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<TeslaCoilBlockEntity> registrar) {
        registrar.register(Capabilities.EnergyStorage.BLOCK, (be, side) -> side == null || !be.isDummy() ? be.energyCap.get() : null);
    }

    public boolean canRun(int energyDrain) {
        return this.isRSPowered() ^ this.redstoneControlInverted && this.energyStorage.getEnergyStored() >= energyDrain;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return new BlockPos(0, 0, -1);
        }
        return BlockPos.ZERO;
    }

    public static class LightningAnimation {
        public Vec3 startPos;
        public LivingEntity targetEntity;
        public Vec3 targetPos;
        private int lifeTimer = 20;
        private final int ANIMATION_MAX = 4;
        private int animationTimer = 4;
        public List<Vec3> subPoints = new ArrayList<Vec3>();
        private Vec3 prevTarget;

        public LightningAnimation(Vec3 startPos, LivingEntity targetEntity) {
            this.startPos = startPos;
            this.targetEntity = targetEntity;
        }

        public LightningAnimation(Vec3 startPos, Vec3 targetPos) {
            this.startPos = startPos;
            this.targetPos = targetPos;
        }

        public boolean shoudlRecalculateLightning() {
            Vec3 end;
            if (this.subPoints.isEmpty() || this.animationTimer == 0) {
                return true;
            }
            boolean b = false;
            Vec3 vec3 = end = this.targetEntity != null ? this.targetEntity.position() : this.targetPos;
            if (this.prevTarget != null) {
                b = this.prevTarget.distanceTo(end) > 1.0;
            }
            this.prevTarget = end;
            return b;
        }

        public void createLightning(RandomSource rand) {
            this.subPoints.clear();
            Vec3 end = this.targetEntity != null ? this.targetEntity.position() : this.targetPos;
            Vec3 dist = end.subtract(this.startPos);
            double points = 12.0;
            int i = 0;
            while ((double)i < points) {
                Vec3 sub = this.startPos.add(dist.x / points * (double)i, dist.y / points * (double)i, dist.z / points * (double)i);
                double fixPointDist = ((double)i - points / 2.0) / (points / 2.0);
                double mod = 1.0 - 0.75 * Math.abs(fixPointDist);
                double offX = (rand.nextDouble() - 0.5) * mod;
                double offY = (rand.nextDouble() - 0.5) * mod;
                double offZ = (rand.nextDouble() - 0.5) * mod;
                if (fixPointDist < 0.0) {
                    offY += 0.75 * mod * (0.75 + fixPointDist);
                    offX = sub.x - this.startPos.x < 0.0 ? -Math.abs(offX) : Math.abs(offX);
                    offZ = sub.z - this.startPos.z < 0.0 ? -Math.abs(offZ) : Math.abs(offZ);
                } else {
                    offY = Math.min(end.y - sub.y + 1.0 * (1.0 - fixPointDist) * -Math.signum(dist.y), offY);
                    offX = Math.abs(offX) * (end.x - sub.x);
                    offZ = Math.abs(offZ) * (end.z - sub.z);
                }
                this.subPoints.add(sub.add(offX, offY, offZ));
                ++i;
            }
            this.animationTimer = 4 + ApiUtils.RANDOM.nextInt(5) - 2;
        }

        public boolean tick() {
            --this.animationTimer;
            --this.lifeTimer;
            return this.lifeTimer <= 0;
        }
    }
}

